setwd("<your path here>")
df1 <- read.csv("20191007 Example 14.2 One Way with Ranks.csv")
#
# df1 has the following columns:
#
# Y
# Group
#
# Note:  Y was simulated so that:
# Group 1 Gamma(shape=2.0,scale=5.0)
# Group 2 Gamma(shape=2.0,scale=5.1)
# Group 3 Gamma(shape=2.4,scale=5.6)
F.null <- c()
R.null <- c()
k.null <- c()
#
# n = 20 in all groups
#
# 
#
#library(dplyr) #has some nice functions for computing groupwise
#               descriptive statistics
#
#group_by(df1,Group)%>%
#summarise(count=n(),mean=mean(Y),sd=sd(Y))
#
set.seed(1) #fixes the random seed for repatability
attach(df1)
f.Group <- as.factor(Group)
rank.Y <- rank(Y)
FT <- anova(lm(Y ~ f.Group))
FR <- anova(lm(rank.Y ~ f.Group))
kw <- kruskal.test(Y ~ f.Group)
F.original <- FT$"F value"[1]
R.original <- FR$"F value"[1]
kw.original <- kw$statistic
nreps <- 2000
for (i in 1:nreps) {
#
# This unused code shows how an actual permutation can be computed:
#  rand <- runif(nrow(df1),0,1) #random numbers between 0 and 1
#  reorder <- Y[order(rand)] 
  reorderY <- sample(x=Y,size=60,replace=TRUE)
  reorderR <- rank(reorderY)
  df2 <- cbind(df1,f.Group,reorderY,reorderR)
  FT.reorderY <- anova(lm(df2$reorderY ~ df2$f.Group))
  FT.reorderR <- anova(lm(df2$reorderR ~ df2$f.Group))

  kw.reorder <- kruskal.test(df2$reorderY ~ df2$f.Group)
  F.null[i] <- FT.reorderY$"F value"[1]
  R.null[i] <- FT.reorderR$"F value"[1]
  k.null[i] <- kw.reorder$statistic
  }
hist(F.null,freq=FALSE)
dev.new()
hist(R.null,freq=FALSE)
dev.new()
hist(k.null,freq=FALSE)
F.null.dst <- ecdf(F.null) #the ecdf() function creates an ecdf function, 
#                           so for example F.null.dst becomes the ecdf of 
#                           variable F.null
#
R.null.dst <- ecdf(R.null)
k.null.dst <- ecdf(k.null)
p.value.F <- 1-F.null.dst(F.original)
p.value.R <- 1-R.null.dst(R.original)
p.value.k <- 1-k.null.dst(kw.original)
F.original
p.value.F
R.original
p.value.R
kw.original
p.value.k


